<?php

namespace Albedo\ScratchCard\Dtos;

class ScratchCardPrizeDto
{

    public function __construct(
        protected string $name,
        protected int    $amount,
    )
    {
    }

    public static function create(
        $name,
        $amount
    ): ScratchCardPrizeDto
    {
        return new self($name, $amount);
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getAmount(): int
    {
        return $this->amount;
    }
}
