<?php

namespace Albedo\ScratchCard\Database\seeders;

use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Enums\ColorEnum;
use Albedo\ScratchCard\Enums\ScratchCardTypeEnum;
use Albedo\ScratchCard\GateLotteryByScratchCardTypeGenerator;
use Albedo\ScratchCard\Models\ScratchCardReason;
use Albedo\ScratchCard\Models\ScratchCardType;
use Albedo\ScratchCard\Services\UserScratchCardService;
use App\Models\User;
use Illuminate\Database\Seeder;

class UserScratchCardSeeder extends Seeder
{
    public function run(): void
    {
        $this->command->alert('Adding scratch card for user');

        $userId = $this->command->ask('Enter user ID to add scratch card:');
        $user = User::findOrFail($userId);
        $scratchCardReasonName = $this->command->choice('Enter scratch card type:', ScratchCardReason::pluck('name', 'id')->toArray());
        $scratchCardReason = ScratchCardReason::where('name', $scratchCardReasonName)
            ->firstOrFail();
        $amount = $this->command->ask('Enter amount of scratch cards to add:', 5);

        for ($i = 0; $i < $amount; $i++) {

            app(UserScratchCardService::class)->addScratchCardResult(
                $user, $scratchCardReason, $user,
            );
        }

        $this->command->info("Adding scratch card for user with ID: $userId");

        $count = $this->command->ask('Count use of scratch cards:', 1);

        for ($i = 0; $i < $count; $i++) {
            app(UserScratchCardService::class)
                ->scratchCardEntryUser(
                    $user,
                    ScratchCardType::query()->where('scratch_card_reason_id', $scratchCardReason->id)
                        ->firstOrFail(),
                );
        }

    }
}
