<?php

use Albedo\ScratchCard\Models\ScratchCardColor;
use Albedo\ScratchCard\Models\ScratchCardReason;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scratch_card_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignIdFor(ScratchCardReason::class)->constrained();
            $table->foreignIdFor(ScratchCardColor::class)->constrained();
            $table->tinyInteger('target');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scratch_card_types');
    }
};
