<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\ScratchCard\Http\Resources\ScratchCardEntryResource;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Facades\Gate;

class InfoScratchCardEntryAction extends Controller
{
    /**
     * Info of scratch card entry.
     * @authenticated
     * @group Scratch card
     */
    public function __invoke(ScratchCardEntry $scratchCardEntry)
    {
        if ($scratchCardEntry->user_id != auth()->id()) {
            abort(404);
        }

        $scratchCardEntry->load('scratchCardPrizeDraw');

        Gate::authorize('view', $scratchCardEntry);

        try {
            return response()
                ->success(
                    message: __('Info of scratch card entry.'),
                    data: ScratchCardEntryResource::make($scratchCardEntry)
                );
        } catch (Exception $e) {
            return response()
                ->error(message: __('System error occurred.'));
        }
    }
}
