<?php

namespace Albedo\ScratchCard;

use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Contracts\PrizeContract;
use Albedo\ScratchCard\Models\Gate;
use Albedo\ScratchCard\Models\ScratchCardGate;
use Albedo\ScratchCard\Models\ScratchCardReason;
use Albedo\ScratchCard\Services\ScratchCardPrizeService;

class GateLotteryByScratchCardTypeGenerator implements LotteryDrawContract
{
    public function __construct(protected ScratchCardReason $scratchCardReason)
    {
    }

    public function drawPrize(): PrizeContract
    {
        $prize = ScratchCardGate::draw($this->scratchCardReason);

        if (is_null($prize)) {
            $prize = ScratchCardPrizeService::getEmptyPrize($this->scratchCardReason);
        }

        return $prize;
    }

}
