<?php

namespace Albedo\ScratchCard\Console\Commands;

use Albedo\ScratchCard\Database\seeders\GateSeeder;
use Albedo\ScratchCard\Database\seeders\ScratchCardColorSeeder;
use Albedo\ScratchCard\Database\seeders\ScratchCardGateSeeder;
use Albedo\ScratchCard\Database\seeders\ScratchCardPrizeSeeder;
use Albedo\ScratchCard\Database\seeders\ScratchCardReasonSeeder;
use Albedo\ScratchCard\Database\seeders\UserScratchCardSeeder;
use Albedo\ScratchCard\Database\seeders\ScratchCardTypeSeeder;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class ScratchCardSeederCommand extends Command
{
    protected $signature = 'scratchcard:seeder';

    protected $description = 'Command description';

    public function handle(): void
    {
        if ($this->getOutput()->confirm('Seeding scratch card color.')) {
            Artisan::call('db:seed', [
                '--class' => ScratchCardColorSeeder::class,
            ], $this->getOutput());
        }

        if ($this->getOutput()->confirm('Seeding scratch card reson.')) {
            Artisan::call('db:seed', [
                '--class' => ScratchCardReasonSeeder::class,
            ], $this->getOutput());
        }
        
        if ($this->getOutput()->confirm('Seeding scratch card tables.')) {
            Artisan::call('db:seed', [
                '--class' => ScratchCardTypeSeeder::class,
            ], $this->getOutput());
        }

        if ($this->getOutput()->confirm('Seeding scratch card prize tables.')) {
            Artisan::call('db:seed', [
                '--class' => ScratchCardPrizeSeeder::class,
            ], $this->getOutput());
        }

        if ($this->getOutput()->confirm('Seeding scratch card gate tables.')) {
            Artisan::call('db:seed', [
                '--class' => ScratchCardGateSeeder::class,
            ], $this->getOutput());
        }

        if ($this->getOutput()->confirm('Seeding scratch card user tables.')) {
            Artisan::call('db:seed', [
                '--class' => UserScratchCardSeeder::class,
            ], $this->getOutput());
        }
    }
}
