<?php

namespace Albedo\ScratchCard\Services;

use Albedo\ScratchCard\Contracts\PrizeContract;
use Albedo\ScratchCard\Dtos\ScratchCardPrizeDto;
use Albedo\ScratchCard\Enums\ScratchCardPrizeOrderStatus;
use Albedo\ScratchCard\Enums\ScratchCardTypeEnum;
use Albedo\ScratchCard\Enums\TypeOfPrizeEnum;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Albedo\ScratchCard\Models\ScratchCardPrizeDraw;
use Albedo\ScratchCard\Models\ScratchCardType;
use App\Http\Resources\UserResource;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class ScratchCardPrizeService
{
    public static function getEmptyPrize(ScratchCardTypeEnum $type): PrizeContract
    {
        $scratchCardType = ScratchCardType::whereType($type)->firstOrFail();

        $scratchCardPrizeDraw = ScratchCardPrizeDraw::firstOrCreate([
            'scratch_card_type_id' => $scratchCardType->id,
            'name' => 'Pusta zdrapka',
        ],[
            'amount' => 1,
            'image' => '',
            'type_of_prize' => TypeOfPrizeEnum::EMPTY
        ]);

        if (!$scratchCardPrizeDraw->wasRecentlyCreated) {
            $scratchCardPrizeDraw->increment('amount');
        }

        return ScratchCardEntry::query()->create([
            'scratch_card_prize_draw_id' => $scratchCardPrizeDraw->id,
            'status' => ScratchCardPrizeOrderStatus::APPROVED,
        ]);
    }

    public function addPrize(
        ScratchCardPrizeDto $scratchCardPrizeDto,
        ScratchCardType     $scratchCardType,
        TypeOfPrizeEnum     $typeOfPrize,
    ): void
    {
        DB::transaction(function () use ($scratchCardPrizeDto, $scratchCardType, $typeOfPrize) {

            $scratchCardPrizeDrawModel = ScratchCardPrizeDraw::query()->create([
                'scratch_card_type_id' => $scratchCardType->id,
                'name' => $scratchCardPrizeDto->getName(),
                'amount' => $scratchCardPrizeDto->getAmount(),
                'image' => $scratchCardPrizeDto->getImage(),
                'type_of_prize' => $typeOfPrize
            ]);

            for ($i = 0; $i < $scratchCardPrizeDto->getAmount(); $i++) {
                $scratchCardPrizeModel = ScratchCardEntry::query()->create([
                    'scratch_card_prize_draw_id' => $scratchCardPrizeDrawModel->id,
                    'status' => ScratchCardPrizeOrderStatus::NO_DATA,
                    'user_id' => null,
                    'drawn_at' => null,
                    'scratched' => 0,
                    'scratch_percentage' => 0
                ]);
            }
        });

    }
}
