<?php

namespace Albedo\ScratchCard\Models;

use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Contracts\PrizeContract;
use Albedo\ScratchCard\Database\factories\ScratchCardTypeFactory;
use Albedo\ScratchCard\Enums\ColorEnum;
use Albedo\ScratchCard\Enums\ScratchCardTypeEnum;
use Albedo\ScratchCard\GateLotteryByScratchCardTypeGenerator;
use Albedo\ScratchCard\GuaranteedPrizeDuelGenerator;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Routing\Exceptions\BackedEnumCaseNotFoundException;

class ScratchCardType extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $guarded = [];

    protected $casts = [
        'type' => ScratchCardTypeEnum::class,
        'color' => ColorEnum::class,
    ];

    public function getPrizeGenerator(): LotteryDrawContract
    {
        return match($this->type){
            ScratchCardTypeEnum::BUSINESS_CARD,
            ScratchCardTypeEnum::DETAIL_CARD => new GateLotteryByScratchCardTypeGenerator($this->type),
            ScratchCardTypeEnum::DUEL => new GuaranteedPrizeDuelGenerator(),
            default => throw new BackedEnumCaseNotFoundException(ScratchCardTypeEnum::class, $this->type),
        };
    }

    /**
     * Create a new factory instance for the model.
     */
    protected static function newFactory(): Factory
    {
        return ScratchCardTypeFactory::new();
    }
}
