<?php

namespace Albedo\ScratchCard\Http\Resources;

use Albedo\ScratchCard\Models\ScratchCardPrizeDraw;
use Albedo\ScratchCard\Models\ScratchCardType;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin ScratchCardPrizeDraw */
class ScratchCardPrizeDrawnResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'scratch_card_type' => ScratchCardTypeResource::make($this->whenLoaded('scratchCardType')),
            'name' => $this->name,
            'image' => url('storage/' . $this->image),
            'type_of_prize' => $this->type_of_prize,
        ];
    }
}
