<?php

namespace Albedo\ScratchCard\Http\Requests;

use Albedo\ScratchCard\Models\ScratchCardEntry;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class OrderAddressRequest extends FormRequest
{
    public function rules(): array
    {
        $scratchCardEntry = ScratchCardEntry::query()
            ->whereId(request()->id)
            ->firstOrFail();

        return $scratchCardEntry->scratchCardPrizeDraw->type_of_prize->requestRules();
    }

    public function authorize(): bool
    {
        return auth()->check();
    }
}
