<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\Ranking\Exceptions\NoRankedShareException;
use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Http\Resources\ScratchCardTypeResource;
use Albedo\ScratchCard\Models\ScratchCardResult;
use Albedo\ScratchCard\Models\ScratchCardType;
use Albedo\ScratchCard\Services\UserScratchCardService;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller as BaseController;
class TypesAction extends BaseController
{
    public function __construct(readonly protected UserScratchCardService $userScratchCardService)
    {

    }

    /**
     * Types
     *
     * @responseFile 200 ../packages/ScratchCard/resources/scribe/types.200.json
     * @group Scratch card
     */
    public function __invoke(Request $request)
    {
        try {

            $types = $this->userScratchCardService->getTypesWithUser($request->user());

            return response()
                ->success(data: ScratchCardTypeResource::collection($types));
        } catch (\Exception $e) {
            report($e);
            return response()->error(message: __('System error occurred.'));
        }
    }
}
