<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\Gamification\Exceptions\GamificationException;
use Albedo\ScratchCard\Exceptions\ConditionsNotAchievedException;
use Albedo\ScratchCard\Http\Requests\OrderScratchCardRequest;
use Albedo\ScratchCard\Http\Resources\ScratchCardEntryResource;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Albedo\ScratchCard\Models\ScratchCardResult;
use Albedo\ScratchCard\Models\ScratchCardType;
use Albedo\ScratchCard\Services\UserScratchCardService;
use Illuminate\Routing\Controller as BaseController;
use Exception;
use Illuminate\Support\Facades\Log;

class OrderAction extends BaseController
{

    public function __construct(readonly protected UserScratchCardService $userScratchCardService)
    {

    }

    /**
     * Order
     *
     * @group Scratch card
     */
    public function __invoke(OrderScratchCardRequest $request)
    {

        try {
            $scratchCardTypeModel = ScratchCardType::findOrFail($request->scratch_card_type_id);

            $scratchCardEntryModel = $this->userScratchCardService->scratchCardEntryUser(
                $request->user(),
                $scratchCardTypeModel,
            );

            $scratchCardEntryModel->load('scratchCardPrizeDraw');

            return response()->success(
                message: __('You have successfully received a scratch card.'),
                data: ScratchCardEntryResource::make($scratchCardEntryModel)
            );
        } catch (ConditionsNotAchievedException $e) {
            return response()->error(message: $e->getMessage());
        } catch (Exception $e) {
            report($e);
            return response()->error(message: __('System error occurred.'));
        }
    }
}
