<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\ScratchCard\Http\Resources\ScratchCardEntryResource;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class InfoScratchCardEntryAction extends Controller
{
    /**
     * Info of scratch card entry.
     *
     * @responseFile 200 ../packages/ScratchCard/resources/scribe/info.200.json
     * @group Scratch card
     */
    public function __invoke(int $id)
    {
        /**
         * TODO Z jakiegoś powodu nie działa bindowanie po modelu.
         *      route api/screatch-cards/{scratchCardEntry} -> __invoke(ScratchCardEntry $scratchCardEntryId)
         *      zwraca pusty model dla zmniennej $scratchCardEntry.
         */

        $scratchCardEntry = ScratchCardEntry::query()
            ->whereUserId(auth()->id())
            ->whereId($id)
            ->with('scratchCardPrizeDraw')
            ->firstOrFail();


        Gate::authorize('view', $scratchCardEntry);

        try {
            return response()
                ->success(
                    message: __('Info of scratch card entry.'),
                    data: ScratchCardEntryResource::make($scratchCardEntry)
                );
        } catch (Exception $e) {
            return response()
                ->error(message: __('System error occurred.'));
        }
    }
}
