<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\ScratchCard\Http\Resources\ScratchCardEntryResource;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller as BaseController;

class HistoryAction extends BaseController
{
    /**
     * History
     *
     * @responseFile 200 ../packages/ScratchCard/resources/scribe/history.200.json
     * @group Scratch card
     */
    public function __invoke(Request $request)
    {
        try {
            $scratchCardEntriesCollection = ScratchCardEntry::query()
                ->with('scratchCardPrizeDraw.scratchCardType')
                ->whereUserId($request->user()->id)
                ->orderBy('drawn_at', 'desc')
                ->get();

            return response()->success(
                message: __('History of scratch cards.'),
                data: ScratchCardEntryResource::collection($scratchCardEntriesCollection)
            );
        } catch (\Exception $e) {
            report($e);
            return response()->error(message: 'System error occurred.');
        }

    }

}
