<?php

namespace Albedo\ScratchCard;

use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Contracts\PrizeContract;
use Albedo\ScratchCard\Enums\ScratchCardPrizeOrderStatus;
use Albedo\ScratchCard\Enums\TypeOfPrizeEnum;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Albedo\ScratchCard\Models\ScratchCardPrizeDraw;
use Albedo\ScratchCard\Models\ScratchCardType;

class GuaranteedPrizeDuelGenerator implements LotteryDrawContract
{
    public function drawPrize(): PrizeContract
    {
        $scratchCardType = ScratchCardType::whereType('duel')->firstOrFail();

        $scratchCardPrizeDraw = ScratchCardPrizeDraw::firstOrCreate([
            'scratch_card_type_id' => $scratchCardType->id,
            'name' => '2000 pkt do bezcennych chwil',
        ],[
            'amount' => 1,
            'image' => '',
            'type_of_prize' => TypeOfPrizeEnum::ELECTRONIC
        ]);

        if (!$scratchCardPrizeDraw->wasRecentlyCreated) {
            $scratchCardPrizeDraw->increment('amount');
        }

        return ScratchCardEntry::query()->create([
            'scratch_card_prize_draw_id' => $scratchCardPrizeDraw->id,
            'status' => ScratchCardPrizeOrderStatus::APPROVED,
        ]);
    }

}
