<?php

namespace Albedo\ScratchCard\Dtos;

class ScratchCardPrizeDto
{

    public function __construct(
        protected string $name,
        protected int    $amount,
        protected string $image,
    )
    {
    }

    public static function create(
        $name,
        $amount,
        $image
    ): ScratchCardPrizeDto
    {
        return new self($name, $amount, $image);
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getAmount(): int
    {
        return $this->amount;
    }

    public function getImage(): string
    {
        return $this->image;
    }

}
