<?php

use Albedo\ScratchCard\Http\Controllers\HistoryAction;
use Albedo\ScratchCard\Http\Controllers\InfoScratchCardEntryAction;
use Albedo\ScratchCard\Http\Controllers\OrderAction;
use Albedo\ScratchCard\Http\Controllers\OrderAddressAction;
use Albedo\ScratchCard\Http\Controllers\TypesAction;
use Albedo\ScratchCard\Http\Controllers\UpdateScratchCardEntryAction;
use Illuminate\Support\Facades\Route;

Route::group([
    'as' => config('scratch-card.route.as'),
    'prefix' => config('scratch-card.route.prefix', 'api/scratch-card'),
    'middleware' => config('scratch-card.route.middleware'),
], function () {

    Route::get('/types', TypesAction::class);
    Route::post('/order', OrderAction::class);
    Route::post('/order-address/{id}', OrderAddressAction::class);
    Route::get('/history', HistoryAction::class);

    Route::get('/{id}', InfoScratchCardEntryAction::class);
    Route::post('/{id}', UpdateScratchCardEntryAction::class);
});
