<?php

namespace Albedo\ScratchCard\Database\seeders;

use Albedo\ScratchCard\Enums\ColorEnum;
use Albedo\ScratchCard\Enums\ScratchCardTypeEnum;
use Albedo\ScratchCard\Models\ScratchCardType;
use Illuminate\Database\Seeder;

class ScratchCardTypeSeeder extends Seeder
{
    public function run(): void
    {
        $this->command->alert('Adding scratch card types.');

        ScratchCardType::updateOrCreate([
            'name' => 'Business Card',
        ],[
            'type' => ScratchCardTypeEnum::BUSINESS_CARD,
            'color' => ColorEnum::GOLD,
            'target' => 7,
            'image' => url('img/scratch-cards/scratch-gold.png'), // TODO
        ]);

        ScratchCardType::updateOrCreate([
            'name' => 'Detail Card',
        ],[
            'type' => ScratchCardTypeEnum::DETAIL_CARD,
            'color' => ColorEnum::GREEN,
            'target' => 7,
            'image' => url('img/scratch-cards/scratch-green.png'), // TODO
        ]);

        ScratchCardType::updateOrCreate([
            'name' => 'Duel',
        ],[
            'type' => ScratchCardTypeEnum::DUEL,
            'color' => ColorEnum::RED,
            'target' => 7,
            'image' => url('img/scratch-cards/scratch-red.png'), // TODO
        ]);;
    }
}
