<?php

namespace Albedo\ScratchCard\Database\seeders;

use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Dtos\ScratchCardPrizeDto;
use Albedo\ScratchCard\Enums\TypeOfPrizeEnum;
use Albedo\ScratchCard\Models\Gate;
use Albedo\ScratchCard\Models\ScratchCardType;
use Albedo\ScratchCard\Services\ScratchCardPrizeService;
use Albedo\ScratchCard\Services\UserScratchCardService;
use Carbon\CarbonPeriod;
use Illuminate\Database\Seeder;

class ScratchCardPrizeSeeder extends Seeder
{
    public function run(): void
    {
        $this->command->alert('Adding scratch card prizes.');

        $scratchCardTypeModels = ScratchCardType::all();
        $typeOfPrizeEnums = collect(TypeOfPrizeEnum::cases());
        $typeOfPrizeEnum = TypeOfPrizeEnum::from($this->command->choice('Enter the type of prizes:', $typeOfPrizeEnums->pluck('value')->toArray(), 0));
        $amount = $this->command->ask('Enter the amount of prizes', 15);

        $scratchCardTypeModels
            ->each(function (ScratchCardType $scratchCardTypeModel) use ($typeOfPrizeEnum, $amount) {

                $prize = app(ScratchCardPrizeService::class)
                    ->addPrize(
                        ScratchCardPrizeDto::create('test', $amount, ''),
                        $scratchCardTypeModel,
                        $typeOfPrizeEnum,
                    );

                $this->command->line(sprintf('Added %d %s %s prizes', $amount, $scratchCardTypeModel->name, $typeOfPrizeEnum->value));

            });

        $this->command->info(sprintf('Created %d scratch card prizes.', $amount * $scratchCardTypeModels->count()));
    }
}
