<?php

namespace Albedo\ScratchCard\Database\seeders;

use Albedo\ScratchCard\Models\Gate;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Carbon\CarbonPeriod;
use Illuminate\Database\Seeder;

class GateSeeder extends Seeder
{
    public function run(): void
    {
        ScratchCardEntry::all()
            ->each(fn(ScratchCardEntry $scratchCardEntry) => Gate::createGate(
                'Bramka',
                CarbonPeriod::create(now(), config('system.end')),
                $scratchCardEntry,
                $scratchCardEntry->scratchCardPrizeDraw->scratchCardType->type->value,
            ));


    }
}
