<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scratch_card_entries', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\Albedo\ScratchCard\Models\ScratchCardPrizeDraw::class)->constrained();
            $table->foreignIdFor(config('scratch-card.user_model'))->constrained();
            $table->dateTime('drawn_at')->nullable();
            $table->boolean('scratched')->default(false);
            $table->boolean('scratch_percentage')->default(false);
            $table->string('status');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scratch_card_entries');
    }
};
