<?php

namespace Albedo\Questionnaire\Filament\Resources\Questionnaires\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Group;
use Filament\Schemas\Schema;
use Illuminate\Support\Str;

class QuestionnaireForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('unique_key')
                    ->unique(ignoreRecord: true)
                    ->default(function ($get) {
                        $name = $get('name');
                        if (!empty($name)) {
                            return Str::slug($name);
                        }
                        return Str::of(Str::random(6))->slug()->upper();
                    })
                    ->afterStateUpdated(function ($set, $get, $state) {
                        if (empty($state) && !empty($get('name'))) {
                            $set('unique_key', Str::slug($get('name')));
                        }
                    }),

                TextInput::make('name')
                    ->required(),
                Group::make()
                    ->schema([
                        DatePicker::make('start')
                            ->label('Start Date')
                            ->required()
                            ->default(now())
                            ->beforeOrEqual('end'),
                        DatePicker::make('end')
                            ->label('End Date')
                            ->required()
                            ->default(now()->addMonth()->endOfMonth())
                            ->afterOrEqual('start'),
                    ])
                    ->columns(2),
                 Textarea::make('payload')
                     ->required(),
            ])

            ->columns(1);
    }
}
