<?php

namespace Albedo\Questionnaire\Filament\Resources\Questionnaires;

use Albedo\Questionnaire\Filament\Resources\Questionnaires\Pages\CreateQuestionnaire;
use Albedo\Questionnaire\Filament\Resources\Questionnaires\Pages\EditQuestionnaire;
use Albedo\Questionnaire\Filament\Resources\Questionnaires\Pages\ListQuestionnaires;
use Albedo\Questionnaire\Filament\Resources\Questionnaires\RelationManagers\QuestionnaireAnswersRelationManager;
use Albedo\Questionnaire\Filament\Resources\Questionnaires\Schemas\QuestionnaireForm;
use Albedo\Questionnaire\Filament\Resources\Questionnaires\Tables\QuestionnairesTable;
use Albedo\Questionnaire\Questionnaire;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class QuestionnaireResource extends Resource
{
    protected static ?string $model = Questionnaire::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    public static function form(Schema $schema): Schema
    {
        return QuestionnaireForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return QuestionnairesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            QuestionnaireAnswersRelationManager::class
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListQuestionnaires::route('/'),
            'create' => CreateQuestionnaire::route('/create'),
            'edit' => EditQuestionnaire::route('/{record}/edit'),
        ];
    }
}
