<?php

namespace Albedo\Questionnaire\Filament\Actions;

use Albedo\Questionnaire\Exports\QuestionnaireAnswersExport;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;

class ExportQuestionnaireAnswersAction extends Action
{
    public static function make(?string $name = null): static
    {
        $actionName = $name ?? 'exportAnswers';

        return parent::make($actionName)
            ->label('Eksportuj odpowiedzi')
            ->icon('heroicon-o-arrow-down-tray')
            ->action(function (Model $record) {
                try {
                    $export = new QuestionnaireAnswersExport($record);
                    $path = '/exports/questionnaire/' . $record->unique_key . '/';
                    $path = str_replace('//', PHP_EOL, $path);

                    $filename = 'questionnaire_' . $record->unique_key . '_answers_' . now()->format('Ymd_His') . '.xlsx';
                    $fullPath = $path . $filename;

                    Excel::store($export, $fullPath, 'local');

                    Notification::make()
                        ->title('Eksport zakończony sukcesem!')
                        ->body('Plik ' . $filename . ' został wygenerowany.')
                        ->success()
                        ->send();

                    return response()->download(Storage::disk('local')->path($fullPath));

                } catch (\Exception $e) {
                    Notification::make()
                        ->title('Błąd podczas eksportu')
                        ->body($e->getMessage())
                        ->danger()
                        ->send();
                }
            });
    }
}
