<?php

namespace Albedo\Questionnaire\Exports;

use Albedo\Questionnaire\Questionnaire;
use Albedo\Questionnaire\QuestionnaireAnswer;
use Illuminate\Database\Eloquent\Builder;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Albedo\Questionnaire\Contracts\QuestionnaireUserExportable;

class QuestionnaireAnswersExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
    protected array $questions = [];
    protected array $additionalUserHeadings = [];

    /**
     * @throws \Exception
     */
    public function __construct(protected Questionnaire $questionnaire)
    {
        $answer = $this->questionnaire->questionnaireAnswers()
            ->where('payload->is_finished', true)
            ->first();

        if (!$answer) {
            throw new \Exception('Brak ukończonych ankiet.');
        }

        $payload = $answer->payload;
        if (isset($payload['export']) && is_array($payload['export'])) {
            foreach ($payload['export'] as $item) {
                if (isset($item['question']) && !empty($item['question'])) {
                    $this->questions[$item['question']] = true;
                }
            }
        }
        $this->questions = array_keys($this->questions);

        $userModel = config('questionnaire.user_model');
        if (class_exists($userModel) && in_array(QuestionnaireUserExportable::class, class_implements($userModel))) {
            $this->additionalUserHeadings = $userModel::getQuestionnaireExportHeadings();
        }
    }

    public function query(): Builder
    {
        return QuestionnaireAnswer::query()
            ->whereQuestionnaireId($this->questionnaire->id)
            ->with('user');
    }

    public function headings(): array
    {
        $headings = ['ID Użytkownika', 'Nazwa Użytkownika'];
        $headings = array_merge($headings, $this->additionalUserHeadings);
        foreach ($this->questions as $question) {
            $headings[] = $question;
        }
        return $headings;
    }

    public function map($answer): array
    {
        $row = [
            $answer->user->id ?? '---',
            $answer->user->name ?? '---',
        ];

        $exportData = [];
        if ($answer->user && in_array(QuestionnaireUserExportable::class, class_implements($answer->user::class))) {
            $exportData = $answer->user->getQuestionnaireExportData();
        }

        foreach ($this->additionalUserHeadings as $heading) {
            $row[] = $exportData[$heading] ?? '';
        }

        $payload = $answer->payload;
        $answerMap = [];

        if (isset($payload['export']) && is_array($payload['export'])) {
            foreach ($payload['export'] as $item) {
                if (isset($item['question'])) {
                    $answerMap[$item['question']] = $item['answer'] ?? '';
                }
            }
        }

        foreach ($this->questions as $question) {
            $row[] = $answerMap[$question] ?? '';
        }

        return $row;
    }
}
