<?php

namespace Albedo\Questionnaire\Contracts;

interface QuestionnaireUserExportable
{
    /**
     * Get additional user data for questionnaire export.
     *
     * @return array<string, mixed> An associative array where keys are column headings and values are data.
     */
    public function getQuestionnaireExportData(): array;

    /**
     * Get the headings for additional user data in questionnaire export.
     *
     * @return array<string>
     */
    public static function getQuestionnaireExportHeadings(): array;
} 