<?php

namespace Albedo\Questionnaire\Database\Factories;

use Albedo\Questionnaire\Questionnaire;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class QuestionnaireFactory extends Factory
{
    protected $model = Questionnaire::class;
    
    public function definition(): array
    {
        return [
            'unique_key' => 'test-key',
            'name' => 'Test Questionnaire',
            'start' => Carbon::now()->startOfDay(),
            'end' => Carbon::now()->addMonth()->endOfDay(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
