<?php

namespace Albedo\Questionnaire\Filament\Resources\Questionnaires\RelationManagers;

use Filament\Actions\Action;
use Filament\Actions\AssociateAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\DissociateAction;
use Filament\Actions\DissociateBulkAction;
use Filament\Actions\EditAction;
use Filament\Forms\Components\TextInput;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Schemas\Schema;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class QuestionnaireAnswersRelationManager extends RelationManager
{
    protected static string $relationship = 'questionnaireAnswers';

    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('id')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('id')
            ->columns([
                TextColumn::make('id'),
                TextColumn::make('user.name')->label('Uczestnik'),
                TextColumn::make('created_at')
                    ->since(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                CreateAction::make(),
                AssociateAction::make(),
            ])
            ->recordActions([
                EditAction::make(),
                DissociateAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DissociateBulkAction::make(),
                    DeleteBulkAction::make(),
                ]),
            ])
            ->headerActions([
                Action::make('viewAnswers')
                    ->label('Podgląd odpowiedzi')
                    ->icon('heroicon-o-eye')
                    ->modalHeading('Podgląd odpowiedzi')
                    ->modalContent(function ($record) {
                        $data = $record->payload;
                        if (!isset($data['export']) || !is_array($data['export'])) {
                            return new HtmlString('Brak odpowiedzi');
                        }
                        $rows = collect($data['export'])->map(function ($item, $i) {
                            $question = e($item['question'] ?? '');
                            $answer = e($item['answer'] ?? '');
                            return '
                                <div class="bg-white dark:bg-gray-900 rounded-lg mb-4 p-4 shadow border border-gray-100 dark:border-gray-800">
                                    <div class="text-xs text-gray-500 dark:text-gray-400 mb-1">Pytanie ' . ($i + 1) . '</div>
                                    <div class="font-semibold mb-2 text-gray-900 dark:text-gray-100">' . $question . '</div>
                                    <div class="text-xs text-primary-600 dark:text-primary-400 font-medium mb-1">Odpowiedź:</div>
                                    <div class="text-sm text-gray-800 dark:text-gray-200">' . $answer . '</div>
                                </div>
                            ';
                        })->implode('');
                        return new HtmlString($rows);
                    })
                    ->modalSubmitAction(false)
                    ->modalCancelActionLabel('Zamknij')
                    ->color('primary')
                    ->outlined()
                    ->visible(fn($record) => !empty($record->payload)),
            ]);
    }
}
