<?php

namespace Albedo\Questionnaire;

use Albedo\Questionnaire\Database\Factories\QuestionnaireFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Questionnaire extends Model {
    use HasFactory;

    protected $casts = [
        'start' => 'datetime',
        'end' => 'datetime',
    ];

    protected $guarded = [];
    protected static function newFactory()
    {
        return QuestionnaireFactory::new();
    }

    public function questionnaireAnswers()
    {
        return $this->hasMany(QuestionnaireAnswer::class);
    }
}
