# Albedo package questionnaire

...

## Installation

To install this package, you need to add the following repository to your `composer.json` in your main project:

```json
"repositories": [
    {
        "type": "composer",
        "url": "https://satis.albedomarketing.net"
    }
],
```

You can install the package via composer:

```bash
composer require albedo/questionnaire
```

You can publish and run the migrations with:

```bash
php artisan vendor:publish --tag="questionnaire-migrations"
php artisan migrate
```

You can publish the config file with:

```bash
php artisan vendor:publish --tag="questionnaire-config"
```

This is the contents of the published config file:

```php
return [
    'route_prefix' => 'api/questionnaire',
    'route_middleware' => [//'auth:sanctum'],
    'user_model' => App\Models\User::class,
];
```

## Usage - API Endpoints

This package provides API endpoints for managing questionnaires. The routes are configurable via `config/questionnaire.php`.

### Route Configuration

YouYou can customize the route prefix and middleware by publishing the configuration file and modifying the `route_prefix` and `route_middleware` options:

```php
// config/questionnaire.php
return [
    // ... existing configuration ...
    'route_prefix' => 'api/your-custom-prefix',
    'route_middleware' => ['your-custom-middleware'],
];
```

### API Response Structure

All API responses from this package follow a consistent `success` or `error` structure:

**Success Response:**

```json
{
    "status": "success",
    "message": "Answer saved successfully.",
    "data": {
        "payload": {
            "foo": "bar"
            // ...
        },
        "answer_id": 1
    },
    "errors": null,
    "meta": []
}
```

**Error Response:**

```json
{
    "status": "error",
    "message": "Unauthenticated.",
    "data": null,
    "errors": null,
    "meta": []
}
```

### Configurable User Model

The package allows you to specify the User model to be used for relationships. By default, it uses `App\Models\User::class`. You can change this in your `config/questionnaire.php`:

```php
// config/questionnaire.php
return [
    // ... existing configuration ...
    'user_model' => App\Models\YourCustomUser::class,
];
```

## Filament Integration

This package provides Filament resources for managing questionnaires. To integrate them into your Filament admin panel, you need to register the `QuestionnairePlugin` in your main project's Filament Panel Provider (e.g., `app/Providers/Filament/AdminPanelProvider.php`).

1.  **Add the plugin to your Panel Provider:**

    Open your `AdminPanelProvider.php` (or equivalent) and add the following:

    ```php
    <?php

    namespace App\Providers\Filament;

    // ... existing imports ...
    use Albedo\Questionnaire\Filament\QuestionnairePlugin; // Add this import

    class AdminPanelProvider extends PanelProvider
    {
        public function panel(Panel $panel): Panel
        {
            return $panel
                // ... existing panel configuration ...
                ->plugin(QuestionnairePlugin::make()); // Add this line
        }
    }
    ```

2.  **Clear Filament and Laravel Cache:**

    After making changes, always clear your application's cache by running these commands in your main project's root directory:

    ```bash
    php artisan optimize:clear
    php artisan config:clear
    php artisan route:clear
    php artisan view:clear
    php artisan filament:cache-clear
    composer dump-autoload
    ```

### Customizing User Data for Export

To include additional user-related columns in the questionnaire answers export, your User model (configured in `config/questionnaire.php` via `user_model`) must implement the `Albedo\Questionnaire\Contracts\QuestionnaireUserExportable` interface.

Here's an example of how your `App\Models\User.php` might look:

```php
<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Albedo\Questionnaire\Contracts\QuestionnaireUserExportable; // Import the interface

class User extends Authenticatable implements QuestionnaireUserExportable
{
    // ... existing code ...

    /**
     * Get additional user data for questionnaire export.
     *
     * @return array<string, mixed> An associative array where keys are column headings and values are data.
     */
    public function getQuestionnaireExportData(): array
    {
        return [
            'Company Name' => $this->company_name, // Example: assuming a 'company_name' column
            'User Role' => $this->getRoleName(), // Example: assuming a getRoleName() method
        ];
    }

    /**
     * Get the headings for additional user data in questionnaire export.
     *
     * @return array<string>
     */
    public static function getQuestionnaireExportHeadings(): array
    {
        return [
            'Company Name',
            'User Role',
        ];
    }
}
```

Make sure the keys in `getQuestionnaireExportData()` match the headings in `getQuestionnaireExportHeadings()`.

## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [kamil.zgodzinski](https://github.com/Kamil Zgodziński)
- [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.

.
