<?php

namespace Albedo\Questionnaire\Http\Action;

use Albedo\Questionnaire\Contracts\QuestionnaireUserProvider;
use Albedo\Questionnaire\Http\Requests\SetAnswerRequest;
use Albedo\Questionnaire\Questionnaire;
use Albedo\Questionnaire\QuestionnaireAnswer;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class QuestionnaireSetAnswerAction
{
    public function __construct(private QuestionnaireUserProvider $questionnaireUserProvider)
    {
    }

    public function __invoke(SetAnswerRequest $request): JsonResponse
    {
        $user = $this->questionnaireUserProvider->getCurrentUser();

        if (!$user) {
            return Response::json(['message' => 'Unauthenticated.'], 401);
        }

        $validated = $request->validated();

        $questionnaire = Questionnaire::query()
            ->where('unique_key', $validated['questionnaire_key'])
            ->first();

        if (!$questionnaire) {
            return Response::json(['message' => 'Questionnaire not found.'], 404);
        }

        if (
            ($questionnaire->start && $questionnaire->start->isFuture()) ||
            ($questionnaire->end && $questionnaire->end->isPast())
        ) {
            return Response::json(['message' => 'Questionnaire is not active.'], 403);
        }

        $questionnaireAnswer = QuestionnaireAnswer::query()->updateOrCreate(
            [
                'user_id' => $user->id,
                'questionnaire_id' => $questionnaire->id,
            ],
            [
                'payload' => $validated['payload'],
            ]
        );

        if ($questionnaire->payload['isFinished'] ?? false) {
            event(new \Albedo\Questionnaire\Events\UserCompletedQuestionnaireEvent(
                $user,
                $questionnaire,
                $questionnaireAnswer
            ));
        }

        return Response::json(['message' => 'Answer saved successfully.']);
    }
}
