<?php

namespace Albedo\Questionnaire\Database\Factories;

use Albedo\Questionnaire\Questionnaire;
use Albedo\Questionnaire\QuestionnaireAnswer;
use Albedo\Questionnaire\Tests\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class QuestionnaireAnswerFactory extends Factory
{
    protected $model = QuestionnaireAnswer::class;

    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'questionnaire_id' => Questionnaire::factory(),
            'payload' => [
                'question_1' => $this->faker->sentence,
                'question_2' => $this->faker->boolean,
            ],
        ];
    }
}
