<?php

namespace Albedo\Questionnaire;

use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use Albedo\Questionnaire\Commands\QuestionnaireCommand;
use Albedo\Questionnaire\Contracts\QuestionnaireUserProvider;
use Albedo\Questionnaire\Providers\DefaultQuestionnaireUserProvider;

class QuestionnaireServiceProvider extends PackageServiceProvider
{
    public function register()
    {
        parent::register();

        $this->app->bind(QuestionnaireUserProvider::class, DefaultQuestionnaireUserProvider::class);
    }

    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('questionnaire')
            ->hasRoute('questionnaire')
            ->hasConfigFile()
            ->hasViews()
            ->hasMigrations([
                '2025_07_21_100707_create_questionnaire_table',
                '2025_07_21_100708_create_questionnaire_answers_table'
            ])
            ->runsMigrations()
            ->hasCommand(QuestionnaireCommand::class);
    }
}
