<?php

namespace Albedo\Questionnaire\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SetAnswerRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'questionnaire_key' => ['required', 'exists:questionnaires,unique_key'],
            'payload' => ['required', 'array'],
            'payload.is_finished' => ['required'],
        ];
    }

    public function authorize(): bool
    {
        return auth()->check();
    }

    protected function prepareForValidation(): void
    {
        if (is_string($this->payload)) {
            $this->merge([
                'payload' => json_decode($this->payload, true),
            ]);
        }
    }
}

