<?php

namespace Albedo\Questionnaire\Http\Action;

use Albedo\Questionnaire\Contracts\QuestionnaireUserProvider;
use Albedo\Questionnaire\Questionnaire;
use Albedo\Questionnaire\QuestionnaireAnswer;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class QuestionnaireProgressAction
{
    public function __construct(private QuestionnaireUserProvider $questionnaireUserProvider)
    {
    }

    public function __invoke($key): JsonResponse
    {
        $user = $this->questionnaireUserProvider->getCurrentUser();

        if (!$user) {
            return Response::error(message: 'Unauthenticated.', status: 401);
        }

        $questionnaire = Questionnaire::query()
            ->where('unique_key', $key)
            ->first();

        if (!$questionnaire) {
            return Response::success(message:'Questionnaire not found', status: 404);
        }

        if (
            ($questionnaire->start && $questionnaire->start->isFuture()) ||
            ($questionnaire->end && $questionnaire->end->isPast())
        ) {
            return Response::success(message: 'Questionnaire is not active', status: 403);
        }

        $answer = QuestionnaireAnswer::query()
            ->where('user_id', $user->id)
            ->where('questionnaire_id', $questionnaire->id)
            ->first();

        if ($answer) {
            return Response::success(data: [
                'payload' => $answer->payload,
            ]);
        }

        return Response::success(data: [
            'payload' => null,
        ]);
    }
}
