# Albedo package questionnaire

...

## Installation

You can install the package via composer:

```bash
composer require albedo/questionnaire
```

You can publish and run the migrations with:

```bash
php artisan vendor:publish --tag="questionnaire-migrations"
php artisan migrate
```

You can publish the config file with:

```bash
php artisan vendor:publish --tag="questionnaire-config"
```

This is the contents of the published config file:

```php
return [
    'route_prefix' => 'api/questionnaire',
    'route_middleware' => [//'auth:sanctum'],
    'user_model' => App\Models\User::class,
];
```

## Usage - API Endpoints

This package provides API endpoints for managing questionnaires. The routes are configurable via `config/questionnaire.php`.

### Route Configuration

YouYou can customize the route prefix and middleware by publishing the configuration file and modifying the `route_prefix` and `route_middleware` options:

```php
// config/questionnaire.php
return [
    // ... existing configuration ...
    'route_prefix' => 'api/your-custom-prefix',
    'route_middleware' => ['your-custom-middleware'],
];
```

### API Response Structure

All API responses from this package follow a consistent `success` or `error` structure:

**Success Response:**

```json
{
    "status": "success",
    "message": "Answer saved successfully.",
    "data": {
        "answer_id": 123
    },
    "errors": null,
    "meta": []
}
```

**Error Response:**

```json
{
    "status": "error",
    "message": "Unauthenticated.",
    "data": null,
    "errors": null,
    "meta": []
}
```

### Configurable User Model

The package allows you to specify the User model to be used for relationships. By default, it uses `App\Models\User::class`. You can change this in your `config/questionnaire.php`:

```php
// config/questionnaire.php
return [
    // ... existing configuration ...
    'user_model' => App\Models\YourCustomUser::class,
];
```


## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [kamil.zgodzinski](https://github.com/Kamil Zgodziński)
- [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.

.
