<?php

namespace Albedo\Questionnaire\Filament\Resources\QuestionnaireResource\RelationManagers;

use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Actions\Action;
use Filament\Tables\Table;
use Illuminate\Support\HtmlString;

class AnswersRelationManager extends RelationManager
{
    protected static string $relationship = 'questionnaireAnswers';
    protected static ?string $recordTitleAttribute = 'id';

    public static function canViewAny(): bool
    {
        return true;
    }

    public function canCreate(): bool
    {
        return false;
    }

    public function canEdit($record): bool
    {
        return false;
    }

    public function canDelete($record): bool
    {
        return false;
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id'),
                Tables\Columns\TextColumn::make('user.name')->label('Uczestnik'),
                Tables\Columns\TextColumn::make('created_at')
                    ->since(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Action::make('viewAnswers')
                    ->label('Podgląd odpowiedzi')
                    ->icon('heroicon-o-eye')
                    ->modalHeading('Podgląd odpowiedzi')
                    ->modalContent(function ($record) {
                        $data = $record->payload;
                        if (!isset($data['export']) || !is_array($data['export'])) {
                            return new HtmlString('Brak odpowiedzi');
                        }
                        $rows = collect($data['export'])->map(function ($item, $i) {
                            $question = e($item['question'] ?? '');
                            $answer = e($item['answer'] ?? '');
                            return '
                                <div class="bg-white dark:bg-gray-900 rounded-lg mb-4 p-4 shadow border border-gray-100 dark:border-gray-800">
                                    <div class="text-xs text-gray-500 dark:text-gray-400 mb-1">Pytanie ' . ($i+1) . '</div>
                                    <div class="font-semibold mb-2 text-gray-900 dark:text-gray-100">' . $question . '</div>
                                    <div class="text-xs text-primary-600 dark:text-primary-400 font-medium mb-1">Odpowiedź:</div>
                                    <div class="text-sm text-gray-800 dark:text-gray-200">' . $answer . '</div>
                                </div>
                            ';
                        })->implode('');
                        return new HtmlString($rows);
                    })
                    ->modalSubmitAction(false)
                    ->modalCancelActionLabel('Zamknij')
                    ->color('primary')
                    ->outlined()
                    ->visible(fn ($record) => !empty($record->payload)),
            ]);
    }
}
