<?php

namespace Albedo\Notification\Http\Controllers;

use Albedo\Notification\Http\Requests\UpdateNotificationPreferencesRequest;
use Albedo\Notification\Models\NotificationPreferenceDisable;
use Albedo\Notification\Services\NotificationPreferencesService;
use Illuminate\Support\Facades\Response;
use Illuminate\Routing\Controller;

class UpdateNotificationPreferencesAction extends Controller
{
    public function __construct(
        protected readonly NotificationPreferencesService $service
    ) {}

    /**
     * @group Notification preferences
     * @response 200
     * @response 422 {"message": "Request contains notification preferences that are not allowed to be edited.", "errors": {"notifications": ["Request contains notification preferences that are not allowed to be edited."]}}
     * @return \Illuminate\Http\JsonResponse
     */
    public function __invoke(UpdateNotificationPreferencesRequest $request)
    {
        $this->service->updatePreferences($request->user(), $request->safe()->all());

        return Response::success();
    }
}
