<?php

namespace Albedo\Notification\Traits;

use Albedo\Notification\Notification;
use Albedo\Notification\NotificationChannelPreference;
use Albedo\Notification\NotificationPreference;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Str;

trait HasNotification {

    use Notifiable;
    public function notifications()
    {
        return $this->morphMany(Notification::class, 'notifiable')->latest();
    }

    public function notificationPreferences()
    {
        return $this->hasMany(NotificationPreference::class);
    }

    public function notificationChannelPreferences()
    {
        return $this->hasMany(NotificationChannelPreference::class);
    }

    public function routeNotificationFor($driver, $notification = null)
    {
        if (method_exists($this, $method = 'routeNotificationFor'.Str::studly($driver))) {
            return $this->{$method}($notification);
        }

        return match ($driver) {
            'database' => $this->notifications(),
            'mail' => $this->email,
            'sms' => $this->phone,
            'mobilePush' => $this->firebaseCloudMessageToken->token,
            default => null,
        };
    }

}
