<?php

namespace Albedo\Notification\Http\Requests;

use Albedo\Notification\Services\NotificationPreferencesService;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Validator;

class UpdateNotificationPreferencesRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            '*' => ['required', 'boolean'],
        ];
    }

    public function authorize(): bool
    {
        return Auth::check();
    }

    public function withValidator(Validator $validator): void
    {
        $validator->after(function (Validator $validator) {

            $service = app(NotificationPreferencesService::class);

            $allowedKeys = collect($service->editableValues());
            $requestKeys = collect($this->all())->keys();

            $notAllowed = $requestKeys->diff($allowedKeys);

            if ($notAllowed->isNotEmpty()) {
                $validator->errors()->add(
                    'notifications',
                    'Request contains notification preferences that are not allowed to be edited.'
                );
            }
        });
    }
}
