<?php

namespace Albedo\Notification\Http\Controllers;

use Albedo\Notification\Services\NotificationPreferencesService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Response;

class NotificationPreferencesAction extends Controller
{
    public function __construct(
        protected readonly NotificationPreferencesService $service
    ) {}

    /**
     * @group Notification preferences
     * @Response 200 {"status": "OK","data": {"channels": [{"type": "channel","label": "E-mail","value": "MailChannel","description": "I agree to receive programme notifications via e-mail to the e-mail address provided during programme registration.","enabled": true,"editable": true},{"type": "channel","label": "SMS","value": "SmsChannel","description": "I agree to receive programme notifications via text message to the mobile number provided during programme registration.","enabled": true,"editable": true},{"type": "channel","label": "Notifications in the mobile app","value": "MobilePushChannel","description": "I agree to receive push notifications about the programme on my device.","enabled": true,"editable": true}],"groups": [{"type": "group","label": "Base","value": "BaseGroupNotification","description": null,"enabled": true,"editable": true,"notification": [{"type": "notification","label": "Testowe powiadomienie","value": "TestNotification","description": null,"enabled": true,"editable": true}]}],"notifications": [{"type": "notification","label": "Testowe powiadomienie","value": "TestNotification","description": null,"enabled": true,"editable": true}]},"meta": [],"message": "","errors": null}
     * @return \Illuminate\Http\JsonResponse
     */
    public function __invoke()
    {
        return Response::success(
            $this->service->build(auth()->user())
        );
    }
}
