<?php

namespace Albedo\Notification\Console\Commands;

use Albedo\Notification\Notifications\TestNotification;
use Illuminate\Console\Command;

class SendTestNotificationCommand extends Command
{
    protected $signature = 'notification:send-test
        {--phone= : Phone number for the test}
        {--email= : Email address for the test}
        {--mobile-token= : Mobile token for the test}';

    protected $description = 'Command description';

    public function handle(): void
    {
        $phone = $this->option('phone');
        $email = $this->option('email');
        $mobileToken = $this->option('mobile-token');

        $user = config('notification.user_model')::query()
            ->where('phone', $phone)
            ->where('email', $email)
            ->firstOr(fn() => config('notification.user_model')::factory()
                 ->create([
                     'phone' => $phone,
                     'email' => $email,
                 ])
            );

        if (!$user->firebaseCloudMessageToken){
            $user->firebaseCloudMessageToken()->create([
                'token' => $mobileToken,
            ]);
        }

        $notification = new TestNotification();

        $user->notify($notification);

        $this->info("✔");
    }
}
