<?php

namespace Albedo\Notification\Services;

use Smsapi\Client\Curl\SmsapiHttpClient;
use Smsapi\Client\Feature\Sms\Bag\SendSmsBag;
use Smsapi\Client\Feature\Sms\Data\Sms;

class SmsApiService
{
    public static function sendSms($number, $message): ?Sms
    {
        if (! $message) {
            return null;
        }

        $service = (new SmsapiHttpClient)->smsapiPlService(config('notification.sms.token'));
        $sms = SendSmsBag::withMessage($number, str_replace(['ą', 'ż', 'ś', 'ź', 'ę', 'ć', 'ń', 'ó', 'ł', 'Ą', 'Ż', 'Ś', 'Ź', 'Ę', 'Ć', 'Ń', 'Ó', 'Ł'], ['a', 'z', 's', 'z', 'e', 'c', 'n', 'o', 'l', 'A', 'Z', 'S', 'Z', 'E', 'C', 'N', 'O', 'L'], $message));
        $sms->from = config('notification.sms.from');
        $sms->test = config('notification.sms.test');

        return $service->smsFeature()->sendSms($sms);
    }
}
