<?php

namespace Albedo\Notification;

use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use Albedo\Notification\Commands\NotificationCommand;

class NotificationServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('notification')
            ->hasConfigFile()
            ->hasViews()
            ->hasRoute('notification')
            ->hasMigration('2025_01_27_131147_create_notifications_table.php')
            ->hasCommand(NotificationCommand::class);
    }
}
