<?php

namespace Albedo\Notification\Http\Controllers;

use Albedo\Notification\Http\Requests\Requests\NotificationGroupRequest;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class ReadNotificationController extends Controller
{
    /**
     * Read notifications
     *
     * Mark as read notifications.
     *
     * You can filter notifications by category by passing the "category" parameter.
     *
     * @group Notification
     */
    public function __invoke(NotificationGroupRequest $request)
    {
        $user = auth()->user();
        $group = $request->input('group');

        try {
            $countReadNotifications = $user
                ->unreadNotifications()
                ->when($group, fn($q) => $q->where('group', $group))
                ->update(['read_at' => now()]);

            return Response::success(message: sprintf('Read %d notifications.', $countReadNotifications));
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }

    }
}
