<?php

namespace Albedo\Notification\Http\Controllers;

use Illuminate\Routing\Controller;
use Exception;
use Illuminate\Support\Facades\Response;

class ListTypeNotificationController extends Controller
{
    /**
     * Categories notifications.
     *
     * @group Notification
     */
    public function __invoke()
    {
        try {
            $groups = config('notification.groups');
            return Response::success(data: $groups, message: "Notifications groups retrieved successfully");
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }
    }
}
