<?php

namespace Albedo\Notification\Channels;

use Illuminate\Notifications\Notification;
use Albedo\Notification\Services\SmsApiService;

class SmsApiChannel
{
    public function send($notifiable, Notification $notification): void
    {
        if (!method_exists($notification, 'toSmsApi')) {
            return;
        }

        $message = $notification->toSmsApi($notifiable);

        $number = $notifiable->routeNotificationFor('smsApi');

        if ($number && $message) {
            SmsApiService::sendSms($number, $message);
        }
    }
}
