<?php

namespace App\Notifications\Channels;

use Exception;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Contract\Messaging;
use Kreait\Firebase\Exception\FirebaseException;
use Kreait\Firebase\Exception\Messaging\NotFound;
use Kreait\Firebase\Exception\MessagingException;
use Kreait\Firebase\Messaging\CloudMessage;

class FirebaseChannel
{

    public function __construct(protected Messaging $messaging)
    {
    }

    /**
     * @throws MessagingException
     * @throws FirebaseException
     * @throws \Exception
     */
    public function send($notifiable, Notification $notification)
    {
        if (!$token = $notifiable->routeNotificationFor('firebase')) {
            return null;
        }

        $message = $notification->toFirebase($notifiable);

        if (!$message instanceof CloudMessage) {
            throw new Exception('Notification must return a CloudMessage instance.');
        }

        try {
            return $this->messaging->send($message->toToken($token));
        } catch (NotFound $notFoundException) {

            Log::warning('Firebase not found token for user '.$notifiable->email, ['token' => $notifiable->firebaseCouldMessageToken?->token]);
            $notifiable->firebaseCouldMessageToken?->delete();

        } catch (Exception $exception) {
            report($exception);
        }
        return null;
    }
}
