<?php

use Albedo\Notification\Http\Controllers\CounterNotificationController;
use Albedo\Notification\Http\Controllers\ListReadNotificationController;
use Albedo\Notification\Http\Controllers\ListTypeNotificationController;
use Albedo\Notification\Http\Controllers\ListUnreadNotificationController;
use Albedo\Notification\Http\Controllers\ReadNotificationController;
use Illuminate\Support\Facades\Route;

Route::group([
     'as' => config('notification.route.as', 'notification.'),
    'prefix' => config('notification.route.prefix', 'api/notification'),
], function () {
    Route::get('unread', ListUnreadNotificationController::class)->name('unread');
    Route::get('read', ListReadNotificationController::class)->name('read');
    Route::post('read', ReadNotificationController::class)->name('mark-as-read');
    Route::get('counter', CounterNotificationController::class)->name('counter');
    Route::get('types', ListTypeNotificationController::class)->name('types');
});
