<?php

namespace Albedo\Notification\Channels;

use Illuminate\Notifications\Notification;
use Albedo\Notification\Services\SmsApiService;

class SmsChannel
{
    public function send($notifiable, Notification $notification): void
    {
        if (!method_exists($notification, 'toSms')) {
            return;
        }

        $message = $notification->toSms($notifiable);

        $number = $notifiable->routeNotificationFor('sms');

        if ($number && $message) {
            SmsApiService::sendSms($number, $message);
        }
    }
}
